
package com.aducid.iface;
import com.aducid.net.soap.*;
import java.util.*;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="version" type="{http://iface.aducid.com}versionType" minOccurs="0"/&gt;
 *         &lt;element name="bindingId" type="{http://iface.aducid.com}authidType" minOccurs="0"/&gt;
 *         &lt;element name="moduleInfo" type="{http://iface.aducid.com}moduleInfoType" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="peigInputType" type="{http://iface.aducid.com}nameType" minOccurs="0"/&gt;
 *         &lt;element name="ppPublicKey" type="{http://iface.aducid.com}pubKeyType" minOccurs="0"/&gt;
 *         &lt;element name="dhpuk1" type="{http://iface.aducid.com}pubKeyType" minOccurs="0"/&gt;
 *         &lt;element name="sZ" type="{http://iface.aducid.com}signedStringType" minOccurs="0"/&gt;
 *         &lt;element name="wait" type="{http://iface.aducid.com}emptyType" minOccurs="0"/&gt;
 *         &lt;element name="echo" type="{http://iface.aducid.com}emptyType" minOccurs="0"/&gt;
 *         &lt;element name="errorMessage" type="{http://iface.aducid.com}errorEnvType" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "version",
    "bindingId",
    "moduleInfo",
    "peigInputType",
    "ppPublicKey",
    "dhpuk1",
    "sz",
    "wait",
    "echo",
    "errorMessage"
})
@XmlRootElement(name = "ADUCIDbinding")
public class ADUCIDbinding {

    protected String version;
    protected byte[] bindingId;
    protected List<ModuleInfoType> moduleInfo;
    protected String peigInputType;
    protected PubKeyType ppPublicKey;
    protected PubKeyType dhpuk1;
    @XmlElement(name = "sZ")
    protected byte[] sz;
    protected EmptyType wait;
    protected EmptyType echo;
    protected ErrorEnvType errorMessage;

    /**
     * Gets the value of the version property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersion(String value) {
        this.version = value;
    }

    /**
     * Gets the value of the bindingId property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    public byte[] getBindingId() {
        return bindingId;
    }

    /**
     * Sets the value of the bindingId property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setBindingId(byte[] value) {
        this.bindingId = value;
    }

    /**
     * Gets the value of the moduleInfo property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the moduleInfo property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getModuleInfo().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ModuleInfoType }
     * 
     * 
     */
    public List<ModuleInfoType> getModuleInfo() {
        if (moduleInfo == null) {
            moduleInfo = new ArrayList<ModuleInfoType>();
        }
        return this.moduleInfo;
    }

    /**
     * Gets the value of the peigInputType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPeigInputType() {
        return peigInputType;
    }

    /**
     * Sets the value of the peigInputType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPeigInputType(String value) {
        this.peigInputType = value;
    }

    /**
     * Gets the value of the ppPublicKey property.
     * 
     * @return
     *     possible object is
     *     {@link PubKeyType }
     *     
     */
    public PubKeyType getPpPublicKey() {
        return ppPublicKey;
    }

    /**
     * Sets the value of the ppPublicKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link PubKeyType }
     *     
     */
    public void setPpPublicKey(PubKeyType value) {
        this.ppPublicKey = value;
    }

    /**
     * Gets the value of the dhpuk1 property.
     * 
     * @return
     *     possible object is
     *     {@link PubKeyType }
     *     
     */
    public PubKeyType getDhpuk1() {
        return dhpuk1;
    }

    /**
     * Sets the value of the dhpuk1 property.
     * 
     * @param value
     *     allowed object is
     *     {@link PubKeyType }
     *     
     */
    public void setDhpuk1(PubKeyType value) {
        this.dhpuk1 = value;
    }

    /**
     * Gets the value of the sz property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    public byte[] getSZ() {
        return sz;
    }

    /**
     * Sets the value of the sz property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setSZ(byte[] value) {
        this.sz = value;
    }

    /**
     * Gets the value of the wait property.
     * 
     * @return
     *     possible object is
     *     {@link EmptyType }
     *     
     */
    public EmptyType getWait() {
        return wait;
    }

    /**
     * Sets the value of the wait property.
     * 
     * @param value
     *     allowed object is
     *     {@link EmptyType }
     *     
     */
    public void setWait(EmptyType value) {
        this.wait = value;
    }

    /**
     * Gets the value of the echo property.
     * 
     * @return
     *     possible object is
     *     {@link EmptyType }
     *     
     */
    public EmptyType getEcho() {
        return echo;
    }

    /**
     * Sets the value of the echo property.
     * 
     * @param value
     *     allowed object is
     *     {@link EmptyType }
     *     
     */
    public void setEcho(EmptyType value) {
        this.echo = value;
    }

    /**
     * Gets the value of the errorMessage property.
     * 
     * @return
     *     possible object is
     *     {@link ErrorEnvType }
     *     
     */
    public ErrorEnvType getErrorMessage() {
        return errorMessage;
    }

    /**
     * Sets the value of the errorMessage property.
     * 
     * @param value
     *     allowed object is
     *     {@link ErrorEnvType }
     *     
     */
    public void setErrorMessage(ErrorEnvType value) {
        this.errorMessage = value;
    }

   public SOAPMessage serialize() {
      SOAPMessage sMessage = new SOAPMessage();
      SOAPMessageHeader smHeader = new SOAPMessageHeader();
      sMessage.setSmHeader(smHeader);
      smHeader.setContentType(SOAPConstants.MIME_TYPE_APPLICATION_SOAP_XML + "; charset=UTF-8");
      SOAPEnvelope sEnvelope = new SOAPEnvelope();
      sMessage.setsEnvelope(sEnvelope);
      SOAPHeader sHeader = new SOAPHeader();
      sEnvelope.setsHeader(sHeader);
      SOAPBody element = new SOAPBody("ADUCIDbinding");
      sEnvelope.setsBody(element);

      if (this.version != null){
         element.addChild(new SOAPElement("version", version));
      }

      if (this.bindingId != null){
         element.addChild(new SOAPElement("bindingId", bindingId));
      }

      if (this.moduleInfo != null){
      if (moduleInfo != null) {
          for (int i = 0; i < moduleInfo.size(); i++) {
          if (moduleInfo.get(i) != null) element.addChild(moduleInfo.get(i).serialize("moduleInfo"));
          }
      }

      }

      if (this.peigInputType != null){
         element.addChild(new SOAPElement("peigInputType", peigInputType));
      }

      if (this.ppPublicKey != null){
         element.addChild(ppPublicKey.serialize("ppPublicKey"));
      }

      if (this.dhpuk1 != null){
         element.addChild(dhpuk1.serialize("dhpuk1"));
      }

      if (this.sz != null){
         element.addChild(new SOAPElement("sZ", sz));
      }

      if (this.wait != null){
         element.addChild(wait.serialize("wait"));
      }

      if (this.echo != null){
         element.addChild(echo.serialize("echo"));
      }

      if (this.errorMessage != null){
         element.addChild(errorMessage.serialize("errorMessage"));
      }

      return sMessage;

   }

   @SuppressWarnings("unchecked")
   public void deserialize(SOAPElement message) {
      if (message == null) {
         return;
      }
      if (message.isEmpty()) {
         return;
      }

      if (message.getElementTextValue("version") != null) {
         version = message.getElementTextValue("version");
      }

      if (message.getElementByteArrayValue("bindingId") != null) {
         bindingId = message.getElementByteArrayValue("bindingId");
      }

      if (message.getAllElementsByTagName("moduleInfo") != null) {
         moduleInfo = new ArrayList<ModuleInfoType>();
         ArrayList<SOAPElement> elements_moduleInfo = message.getAllElementsByTagName("moduleInfo");
         for (SOAPElement x : elements_moduleInfo) {
            ModuleInfoType tmp = new ModuleInfoType();
            tmp.deserialize(x);
            moduleInfo.add(tmp);
         }
      }

      if (message.getElementTextValue("peigInputType") != null) {
         peigInputType = message.getElementTextValue("peigInputType");
      }

      if (message.getElementByTagName("ppPublicKey") != null) {
         ppPublicKey = new PubKeyType();
         ppPublicKey.deserialize(message.getElementByTagName("ppPublicKey"));
      }

      if (message.getElementByTagName("dhpuk1") != null) {
         dhpuk1 = new PubKeyType();
         dhpuk1.deserialize(message.getElementByTagName("dhpuk1"));
      }

      if (message.getElementByteArrayValue("sZ") != null) {
         sz = message.getElementByteArrayValue("sZ");
      }

      if (message.getElementByTagName("wait") != null) {
         wait = new EmptyType();
         wait.deserialize(message.getElementByTagName("wait"));
      }

      if (message.getElementByTagName("echo") != null) {
         echo = new EmptyType();
         echo.deserialize(message.getElementByTagName("echo"));
      }

      if (message.getElementByTagName("errorMessage") != null) {
         errorMessage = new ErrorEnvType();
         errorMessage.deserialize(message.getElementByTagName("errorMessage"));
      }


   }

}
