var cat_srv = 'CATALOG_ADDRESS';

function callPeig(url) {
	location.href = url;
	return false;
}

function getPrefix() {
	return "";
}

function sendText() {
	var x = document.getElementById('peig-text-input').value;
	callPeig('http://peigdirective?textresult=' + encodeURIComponent(x));
}

(function() {
	var input = document.getElementById("peig-text-input");
	if (input != null) {
		input.addEventListener('keypress', function(e) {
			if (e.key === 'Enter') {
				sendText();
			}
		});
	}
})();


(function() {
	var input = document.getElementById("peig-search");
	if (input != null) {
		input.addEventListener('focus', function() {
			var x = document.getElementsByClassName("app-button-hide");
			for (let i = 0; i < x.length; i++) {
				x[i].classList.add("hidden");
			}
		});

		input.addEventListener('blur', function() {
			var x = document.getElementsByClassName("app-button-hide");
			for (let i = 0; i < x.length; i++) {
				x[i].classList.remove("hidden");
			}
		});
	}
})();

var workspaces = [];
var workspace = null;
var workspaceUrl = null;

function setWorkspace(i) {
	workspace = workspaces[i];
	var x = document.getElementById('workspace-div');
	workspaceUrl = workspace.url;
	var hint = document.getElementById("workspace-hints");
	if (hint != null) hint.innerHTML = "";
	x.innerHTML = "<div class='h4 text-center'>" + "You have selected workspace</div>" + "<h2 class='mt-3 text-success text-center'>" + workspace.name + "</h2> ";

	var btn = document.getElementById('workspace-confirm');
	btn.classList.remove('hidden');

	var btn2 = document.getElementById('workspace-cancel');
	btn2.classList.remove('hidden');

	var btn2 = document.getElementById('check-workspace');
	btn2.classList.add('hidden');
}

function checkWorkspace(seq) {
	if (seq == null || seq == 'undefined') seq = 0;
	var x = document.getElementById('workspace-input').value;

	if (workspaces != null) {
		var i = 0;
		for (var w of workspaces) {
			if (x.toLowerCase() == w.name.toLowerCase()) {
				setWorkspace(i);
				return;
			}
			i++;
		}
	}
	if (x.indexOf(".") == -1) return;


	if (x.indexOf("https://") == -1) {
		x = "https://" + x;
	}

	var btn2 = document.getElementById('check-workspace');
	var input = document.getElementById('workspace-input');
	var hint = document.getElementById("workspace-hints");

	if (seq >= 2) {
		btn2.classList.remove('hidden');
		input.disabled = false;
		hint.innerHTML = "<div class='search-window text-danger text-center'>" + "This is not a valid workspace. Please check address." + "</div>";
	}
	else {
		input.disabled = true;
		btn2.classList.add('hidden');
		hint.innerHTML = "<div class='search-window text-center'>" + "Checking workspace ...." + "</div>";
	}

	if (seq == 0) { checkPing(x, seq); }
	if (seq == 1) { checkPing(x + "/aducid-join", seq); }
}

function checkPing(x, seq) {
	const xhttp = new XMLHttpRequest();
	xhttp.onload = function() {
		if (!this.responseText.startsWith("ADUCID")) {
			checkWorkspace(seq + 1);
			return;
		}

		var hint = document.getElementById("workspace-hints");
		if (hint != null) hint.innerHTML = "";

		var div = document.getElementById('workspace-div');
		div.innerHTML = "<div class='h4 text-center'>" + "You have selected workspace</div>" + "<h2 class='mt-3 text-success text-center'>" + x + "</h2> ";


		var btn = document.getElementById('workspace-confirm');
		btn.classList.remove('hidden');

		var btn2 = document.getElementById('workspace-cancel');
		btn2.classList.remove('hidden');

		var btn2 = document.getElementById('check-workspace');
		btn2.classList.add('hidden');

		workspaceUrl = x;
	}
	xhttp.onerror = function() {
		checkWorkspace(seq + 1);
	}
	xhttp.open("GET", x + "/AIM/services/R3/ping");
	xhttp.send();
}

function confirmWorkspace() {
	callPeig('http://peigdirective?textresult=' + encodeURIComponent(workspaceUrl));
}

(function() {
	var input = document.getElementById("workspace-input");
	if (input != null) {
		input.addEventListener('keypress', function(e) {
			if (e.key === 'Enter') {
				checkWorkspace();
			}
		});
	}
})();

(function() {
	var input = document.getElementById("workspace-input");
	var hint = document.getElementById("workspace-hints");
	if (input != null) {
		input.addEventListener('keyup', function(e) {
			const xhttp = new XMLHttpRequest();
			var x = input.value;
			xhttp.onload = function() {
				var response = JSON.parse(this.responseText).data;
				workspaces = response;
				var s = "";
				for (var i = 0; i < response.length; i++) {
					var cls = "";
					var txt = "";
					var clk = "";

					if (response[i].runtimeStatus == "OFFLINE") {
						cls = " text-danger";
						txt = " (OFFLINE)";
					}
					else {
						if (response[i].status == "ACTIVE") {
							cls = "";
						}
						else if (response[i].status == "READY") {
							cls = " clickable text-success";
							txt = " (READY)";
						}
						else {
							cls = " clickable text-warning";
							txt = " (NEW)";
						}

						clk = " onClick='setWorkspace(" + i + ");return false;' ";
					}
					s += "<a href='#' class='fs-14 list-group-item bg-white text-main  " + cls + "' " + clk + ">" + response[i].name + txt + "</a>";
				}
				if (s == "") {
					hint.innerHTML = "<div class='search-window text-center text-warning'>" + "No workspace found" + "</div>";
				}
				else {
					hint.innerHTML = s;
				}
			}

			xhttp.onerror = function() {
				hint.innerHTML = "<div class='search-window'>" + "Catalog not available" + "</div>";
			}

			if (x != null && x != "") {
				xhttp.open("GET", cat_srv + x);
				xhttp.send();
			}
			else { hint.innerHTML = ""; }
		});
	}
})();


var defocus = "";
(function() {
	if (document.getElementById("peig-search") != null) {
		document.getElementsByTagName("BODY")[0].scrollTop = 0;
	}
})();


function openPage(e) {
	var x = document.getElementById('peig-search').value;
	if (e.which === 13 || e.charCode === 13 || e.keyCode === 13) {
		callPeig('http://peigdirective?search=' + encodeURIComponent(x));
		return;
	}
}

function clearSearch() {
	var x = document.getElementById('peig-search');
	x.value = "";
}


function openSearch() {
	var x = document.getElementById('peig-search').value;
	var y = document.getElementById('peig-browser');

	if (y != null && x != '') {
		callPeig('http://peigdirective?websearch=' + encodeURIComponent(x) + "&position=" + document.getElementById('peig-search').selectionStart);
	}


	if (x == "") {
		document.getElementById('main-search').classList.add('hidden');
		document.getElementById('main-normal').classList.remove('hidden');
		return;
	}

	if (document.getElementById('main-search') != null) document.getElementById('main-search').classList.remove('hidden');
	if (document.getElementById('main-normal') != null) document.getElementById('main-normal').classList.add('hidden');

	x = x.toLowerCase();

	const xhttp = new XMLHttpRequest();
	xhttp.onload = function() {
		var target = document.getElementById('main-search');
		target.innerHTML = this.responseText;
	}
	xhttp.onerror = function() {
	}
	xhttp.open("GET", getPrefix() + "/peig-search?q=" + x);
	xhttp.send();
}

var tmpSearch = document.getElementById('peig-search').getAttribute("data-search");
if (tmpSearch != null && tmpSearch != "") {
	var tmpSearchPos = document.getElementById('peig-search').getAttribute("data-search-pos");
	openSearch();
	document.getElementById('peig-search').focus();
	document.getElementById('peig-search').value = "";
	document.getElementById('peig-search').value = tmpSearch;
	if (tmpSearchPos > 0) {
		document.getElementById('peig-search').selectionStart = tmpSearchPos;
		document.getElementById('peig-search').selectionEnd = tmpSearchPos;
	}

}

var pinLength = 0;

function changePin() {
	const PSY = "<span></span>";
	pinLength++;
	var x = document.getElementById('pin-box');
	x.insertAdjacentHTML('beforeend', PSY);
	document.getElementById('ok').classList.remove('hidden');
	if (document.getElementById('select') != null) document.getElementById('select').classList.add('hidden');

}

function switcher(x) {
	document.getElementById('switch-1').classList.remove('switcher-active');
	document.getElementById('switch-2').classList.remove('switcher-active');
	document.getElementById('switch-' + x).classList.add('switcher-active');

	document.getElementById('switch-content-1').style.display = "none";
	document.getElementById('switch-content-2').style.display = "none";
	document.getElementById('switch-content-' + x).style.display = "block";
}

function toggleSwich(x) {
	x.getElementsByClassName("switch-inner")[0].classList.toggle("checked");
}

function toggleStarredConfig() {
	var x = document.getElementsByClassName("starred-item__options");
	for (let i = 0; i < x.length; i++) {
		x[i].classList.toggle("hidden");
	}
}

function showStarredAll() {
	var x = document.getElementsByClassName("starred-div");
	for (let i = 0; i < x.length; i++) {
		x[i].classList.remove("hidden");
	}
	document.getElementById('starred-all-button').classList.add('hidden');
	document.getElementById('starred-hide-button').classList.remove('hidden');
}

function hideStarredAll() {
	var x = document.getElementsByClassName("starred-div");
	for (let i = 0; i < x.length; i++) {
		x[i].classList.add("hidden");
	}
	document.getElementById('starred-all-button').classList.remove('hidden');
	document.getElementById('starred-hide-button').classList.add('hidden');
}

var settingsPage = 0;
function showSettings(page, cmd) {
	if (page == -1) {
		if (settingsPage > 0) {
			callPeig('http://peigdirective?command=SETTINGS');
		}
		else {
			if (cmd == null || cmd == "" || cmd == "null") {
				callPeig('http://peigdirective?command=MAIN');
			}
			else {
				callPeig('https://load?' + cmd);
			}

		}

		return;
	}
	var x = document.getElementsByClassName("settings-right");
	for (let i = 0; i < x.length; i++) {
		x[i].classList.add("hidden");
	}
	document.getElementById('settings-page-' + page).classList.remove('hidden');

	if (window.innerWidth < 700) {
		document.getElementById('settings-left').classList.add('hidden');
	}
	settingsPage = page;
}

function bookmark() {
	var b = document.getElementById("bookmark");
	if (b.innerHTML.indexOf("icon-star-full") > -1) {
		b.innerHTML = "<span class='addressbar__icon'><svg><use xlink:href='sprite.svg#icon-star'></use></svg></span>";
	}
	else {
		b.innerHTML = "<span class='addressbar__icon'><svg><use xlink:href='sprite.svg#icon-star-full'></use></svg></span>";
	}

}


function fixFocus(x) {
}

function fixBlur() {
}


function downloadRefresh() {
	setInterval(function() {
		const xhttp = new XMLHttpRequest();
		xhttp.onload = function() {
			var target = document.getElementById('downloads');
			target.innerHTML = this.responseText;
		}
		xhttp.onerror = function() {
		}
		xhttp.open("GET", getPrefix() + "/peig-download");
		xhttp.send();
	}, 1000);
}
function refresh(page) {
	const xhttp = new XMLHttpRequest();
	xhttp.onload = function() {
		var target = document.getElementById('main');
		target.innerHTML = this.responseText;
	}
	xhttp.onerror = function() {
	}
	xhttp.open("GET", getPrefix() + "/peig-" + page);
	xhttp.send();
}
